export type ContributorRole = 'order_manager' | 'designer_assistant' | 'custom';
export type ContributorPermission = 'manage_orders' | 'send_reminders' | 'view_customers' | 'manage_discounts' | 'custom';

export interface Contributor {
  id: string;
  vendor_id: string;
  name: string;
  email: string;
  role: ContributorRole;
  permissions: ContributorPermission[];
  is_active: boolean;
  created_at: string;
  updated_at: string;
}

export type DiscountType = 'percentage' | 'fixed';
export type DiscountAppliesTo = 'product' | 'order' | 'customer';

export interface Discount {
  id: string;
  vendor_id: string;
  type: DiscountType;
  value: number;
  applies_to: DiscountAppliesTo;
  target_id: string;
  auto_apply: boolean;
  starts_at: string;
  expires_at: string;
  is_active: boolean;
  created_at: string;
  updated_at: string;
}

export interface AddContributorRequest {
  name: string;
  email: string;
  role: ContributorRole;
  permissions: ContributorPermission[];
}

export interface UpdateContributorRequest {
  role?: ContributorRole;
  permissions?: ContributorPermission[];
}

export interface CreateDiscountRequest {
  type: DiscountType;
  value: number;
  applies_to: DiscountAppliesTo;
  target_id: string;
  auto_apply: boolean;
  starts_at: string;
  expires_at: string;
}

export interface UpdateDiscountRequest {
  type?: DiscountType;
  value?: number;
  applies_to?: DiscountAppliesTo;
  target_id?: string;
  auto_apply?: boolean;
  starts_at?: string;
  expires_at?: string;
  is_active?: boolean;
} 